﻿using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using PpmsDataWebService.Models;
using VA.PPMS.Context;

namespace PpmsDataWebService.Mappers
{
    public class AgreementProvidersMap
    {
        public static async Task<IQueryable<AgreementProvider>> MapAgreementProviders(List<ppms_agreementprovider> ppmsAgreementProviders, string mapRelatedType, PpmsContext context)
        {
            var agreementProviders = new List<AgreementProvider> { };
            foreach (var ppmsAgreementProvider in ppmsAgreementProviders)
            {
                var agreementProvider = new AgreementProvider
                {
                    Name = ppmsAgreementProvider.ppms_name,
                };


                if (ppmsAgreementProvider.ppms_ProviderGroup != null)
                    agreementProvider.ProviderGroupName = ppmsAgreementProvider.ppms_ProviderGroup.Name;
                if (ppmsAgreementProvider.ppms_providerservice != null)
                    agreementProvider.ProviderServiceName = ppmsAgreementProvider.ppms_providerservice.Name;
                if (ppmsAgreementProvider.ppms_ExternalProvider != null)
                    agreementProvider.ExternalProviderName = ppmsAgreementProvider.ppms_ExternalProvider.Name;
                if (ppmsAgreementProvider.ppms_ProviderAgreement != null)
                    agreementProvider.ProviderAgreementName = ppmsAgreementProvider.ppms_ProviderAgreement.Name;
                if (ppmsAgreementProvider.ppms_VAProviderRelationshipId != null)
                    agreementProvider.VaProviderRelationshipName = ppmsAgreementProvider.ppms_VAProviderRelationshipId.Name;


                //Extract the Related type from queryType string

                if (mapRelatedType.Contains("?$expand=ExternalProvider"))
                    mapRelatedType = "ExternalProvider";
                if (mapRelatedType.Contains("?$expand=ProviderGroup"))
                    mapRelatedType = "ProviderGroup";
                if (mapRelatedType.Contains("?$expand=ProviderAgreement"))
                    mapRelatedType = "ProviderAgreement";

                //Map Related types switch. 
                switch (mapRelatedType)
                {

                    case "ExternalProvider":
                        //Lookup and Map the Provider
                        var ppmsExternalProvider =
                            context.AccountSet.FirstOrDefault(i => i.Id == ppmsAgreementProvider.ppms_ExternalProvider.Id);
                        var ppmsExternalProviderList = new List<Account> { ppmsExternalProvider };
                        agreementProvider.ExternalProvider =
                            await ProviderMap.MapProviders(ppmsExternalProviderList, "None");
                        break;
                    case "ProviderGroup":
                        //Lookup and Map the Provider
                        var ppmsProviderGroup =
                            context.AccountSet.FirstOrDefault(i => i.Id == ppmsAgreementProvider.ppms_ProviderGroup.Id);
                        var ppmsProviderGroupList = new List<Account> { ppmsProviderGroup };
                        agreementProvider.ProviderGroup =
                            await ProviderMap.MapProviders(ppmsProviderGroupList, "None");
                        break;
                    case "ProviderAgreement":
                        //Lookup and Map the Provider
                        var ppmsProviderAgreement =
                            context.ppms_provideragreementSet.FirstOrDefault(i => i.Id == ppmsAgreementProvider.ppms_ProviderAgreement.Id);
                        var ppmsProviderAgreementList = new List<ppms_provideragreement> { ppmsProviderAgreement };
                        agreementProvider.ProviderAgreement =
                            await ProviderAgreementsMap.MapProviderAgreements(ppmsProviderAgreementList, "None", context);
                        break;
                    default:
                        break;
                }

                agreementProviders.Add(agreementProvider);
            }
            return agreementProviders.AsQueryable();
        }
    }
}